﻿//////////////////////////////////////////////
// BlendStateManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Utils/Manager.h"

#include "BlendState.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------
	
namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT BlendStateManager : public Manager<BlendState>, public nkCommon::MaybeSingletonClass<BlendStateManager>
	{
		public :

			// Getters
			BlendState* getDefaultState () const ;

		private :

			// Constructors
			BlendStateManager (bool isSingleton) noexcept ;
			BlendStateManager (System* system) noexcept ;

			// Lifetime
			void _initializeDefaultState () ;

		private :

			// Attributes
			nkMemory::UniquePtr<BlendState> _defaultState ;

		private :

			friend class nkCommon::MaybeSingletonClass<BlendStateManager> ;
			friend class System ;
	} ;
}